﻿Public Class MainForm
    Dim enabledBit As Integer
    Dim swStopBit As Integer
    Dim startMotBit As Integer
    Dim homeBit As Integer
    Dim stopMotBit As Integer
    Dim Initialized = False

    '*******************************************************************************
    '* Stop polling when the form is not visible in order to reduce communications
    '* Copy this section of code to every new form created
    '*******************************************************************************
    Private Sub Form_VisibleChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.VisibleChanged
        AdvancedHMIDrivers.Utilities.StopComsOnHidden(components, Me)
    End Sub

    Private Sub Button1_Click(sender As Object, e As EventArgs)
        Page2.Show()
        Me.Hide()
    End Sub



    Private Sub Button1_Click_1(sender As System.Object, e As System.EventArgs) Handles ButtonEnable.Click

        If ((enabledBit And &H1) = &H1) Then
            enabledBit = enabledBit And Not &H1
            ButtonEnable.Text = "Not Enabled"
            ButtonEnable.BackColor = Color.Gray
        Else
            enabledBit = enabledBit Or &H1
            ButtonEnable.Text = "Enabled"
            ButtonEnable.BackColor = Color.Green
        End If

        Dim combine As Integer

        'Some of these combinations may not be valid - check the modbus documentation for valid combinations
        combine = swStopBit Or enabledBit Or startMotBit Or homeBit Or stopMotBit

        CheckValidity(combine)

        Dim value As Integer

        Try
            value = Convert.ToInt16(ComboBoxMoveSelect.Text)
        Catch
            Return
        End Try

        value = value << 8
        combine = combine Or value
        Dim res As String()
        res = {String.Empty, String.Empty} 'Two registers contain status

        If (RadioButtonModbusTCP.Checked) Then
            Try
                ModbusTCPCom1.Write("404001", combine.ToString())
                res = ModbusTCPCom1.Read("404001", 2)
                TimerCheckStatus.Enabled = True
            Catch
                TimerCheckStatus.Enabled = False
            End Try

        End If


    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles ButtonSoftwareStop.Click
        If ((swStopBit And &H8) = &H8) Then
            swStopBit = swStopBit And Not &H8
            ButtonSoftwareStop.Text = "Software Stop Not Enabled"
            ButtonSoftwareStop.BackColor = Color.Gray
        Else
            swStopBit = swStopBit Or &H8
            ButtonSoftwareStop.Text = "Software Stop Enabled"
            ButtonSoftwareStop.BackColor = Color.Red

        End If
        Dim combine As Integer

        'Some of these combinations may not be valid - check the modbus documentation for valid combinations
        combine = swStopBit Or enabledBit Or startMotBit Or homeBit Or stopMotBit
        CheckValidity(combine)

        Dim value As Integer

        Try
            value = Convert.ToInt16(ComboBoxMoveSelect.Text)
        Catch
            Return
        End Try

        value = value << 8
        combine = combine Or value


        If (RadioButtonModbusTCP.Checked) Then
            Try
                ModbusTCPCom1.Write("404001", combine.ToString())
                TimerCheckStatus.Enabled = True
            Catch
                TimerCheckStatus.Enabled = False
            End Try


        End If


    End Sub

    Private Sub ButtonStartMotion_Click(sender As System.Object, e As System.EventArgs) Handles ButtonStartMotion.Click
        If ((startMotBit And &H2) = &H2) Then
            startMotBit = startMotBit And Not &H2
            ButtonStartMotion.Text = "Start Mottion Low"
            ButtonStartMotion.BackColor = Color.Gray
        Else
            startMotBit = startMotBit Or &H2
            ButtonStartMotion.Text = "Start Motion High"
            ButtonStartMotion.BackColor = Color.Green
        End If

        Dim combine As Integer

        'Some of these combinations may not be valid - check the modbus documentation for valid combinations
        combine = swStopBit Or enabledBit Or startMotBit Or homeBit Or stopMotBit
        CheckValidity(combine)

        Dim value As Integer

        Try
            value = Convert.ToInt16(ComboBoxMoveSelect.Text)
        Catch
            Return
        End Try

        value = value << 8
        combine = combine Or value


        If (RadioButtonModbusTCP.Checked) Then
            Try
                ModbusTCPCom1.Write("404001", combine.ToString())
                TimerCheckStatus.Enabled = True
            Catch
                TimerCheckStatus.Enabled = False
            End Try

        End If

    End Sub

    Private Sub ButtonHome_Click(sender As System.Object, e As System.EventArgs) Handles ButtonHome.Click
        If ((homeBit And &H4) = &H4) Then
            homeBit = homeBit And Not &H4
            ButtonHome.Text = "Home Low"
            ButtonHome.BackColor = Color.Gray
        Else
            homeBit = homeBit Or &H4
            ButtonHome.Text = "Home High"
            ButtonHome.BackColor = Color.Green
        End If

        Dim combine As Integer

        'Some of these combinations may not be valid - check the modbus documentation for valid combinations
        combine = swStopBit Or enabledBit Or startMotBit Or homeBit Or stopMotBit
        CheckValidity(combine)

        Dim value As Integer

        Try
            value = Convert.ToInt16(ComboBoxMoveSelect.Text)
        Catch
            Return
        End Try

        value = value << 8
        combine = combine Or value

        If (RadioButtonModbusTCP.Checked) Then
            Try
                ModbusTCPCom1.Write("404001", combine.ToString())
                TimerCheckStatus.Enabled = True
            Catch
                TimerCheckStatus.Enabled = False
            End Try

        End If
    End Sub

    Private Sub ButtonStopMotion_Click(sender As System.Object, e As System.EventArgs) Handles ButtonStopMotion.Click
        If ((stopMotBit And &H10) = &H10) Then
            stopMotBit = stopMotBit And Not &H10
            ButtonStopMotion.Text = "Stop Motion Disabled"
            ButtonStopMotion.BackColor = Color.Gray
        Else
            stopMotBit = stopMotBit Or &H10
            ButtonStopMotion.Text = "Stop Motion Enabled"
            ButtonStopMotion.BackColor = Color.Green
        End If

        Dim combine As Integer

        'Some of these combinations may not be valid - check the modbus documentation for valid combinations
        combine = swStopBit Or enabledBit Or startMotBit Or homeBit Or stopMotBit
        CheckValidity(combine)

        Dim value As Integer

        Try
            value = Convert.ToInt16(ComboBoxMoveSelect.Text)
        Catch
            Return
        End Try

        value = value << 8
        combine = combine Or value


        If (RadioButtonModbusTCP.Checked) Then
            Try
                ModbusTCPCom1.Write("404001", combine.ToString())
                TimerCheckStatus.Enabled = True
            Catch
                TimerCheckStatus.Enabled = False
            End Try

        End If
    End Sub

    Private Sub MainForm_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        Dim res As String

        Initialized = True

        LabelApplicationVersion.Text = "Version " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.ToString()

        res = "0"
        TextBoxIPAddress.Text = ModbusTCPCom1.IPAddress
        ComboBoxMotionType.SelectedIndex = 0

        Try
            res = ModbusTCPCom1.Read("304001")
            PanelConnection.BackColor = Color.Green
            LabelConnectionStatus.Text = "Connected"
            TimerCheckStatus.Enabled = True
        Catch
            PanelConnection.BackColor = Color.DarkCyan
            LabelConnectionStatus.Text = "Disconnected"
            Return
        End Try


        enabledBit = Convert.ToInt32(res) And &H1
        swStopBit = Convert.ToInt32(res) And &H8


        If (enabledBit > 0) Then
            ButtonEnable.Text = "Enabled"
            ButtonEnable.BackColor = Color.Green
            TimerCheckStatus.Enabled = True
        Else
            ButtonEnable.Text = "Not Enabled"
            ButtonEnable.BackColor = Color.Gray
        End If

        If (swStopBit > 0) Then
            ButtonSoftwareStop.Text = "Software Stop Enabled"
            ButtonSoftwareStop.BackColor = Color.Red
            TimerCheckStatus.Enabled = True
        Else
            ButtonSoftwareStop.Text = "Software Stop Not Enabled"
            ButtonSoftwareStop.BackColor = Color.Gray
        End If



    End Sub

    Private Sub TextBoxIPAddress_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBoxIPAddress.TextChanged
        ModbusTCPCom1.IPAddress = TextBoxIPAddress.Text
    End Sub


    ''' <summary>
    ''' Validates command against model
    ''' </summary>
    ''' <param name="input"></param>
    ''' <remarks>only certain combinations of bits are allowed.  we can check these using our modbus documentation</remarks>
    ''' 
    Private Sub CheckValidity(input As Int32)
        If ((input = 0) Or (input = 1) Or (input = 3) Or (input = 5) Or (input = 8) Or (input = 9) Or (input = 17)) Then
            LabelValidityCheck.Text = "command combination valid"
            LabelValidityCheck.ForeColor = Color.Green
        Else
            LabelValidityCheck.Text = "command combination may not be valid"
            LabelValidityCheck.ForeColor = Color.Red
        End If

    End Sub

    Dim PollInfoCounter As Int32

    ''' <summary>
    ''' Update Status Timer
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks>This continuously updates the status bits</remarks>
    Private Sub TimerCheckSWStop_Tick(sender As System.Object, e As System.EventArgs) Handles TimerCheckStatus.Tick
        Static Dim Running As Boolean


        If (Not Running) Then
            Running = True
            PollInfoCounter = 0
            Dim startTime As DateTime = DateTime.Now

            Dim res As String()
            res = {String.Empty, String.Empty} 'Two registers contain status

            CheckPosition()
            CheckFaults()
            UpdateDigitalInputs()

            If (RadioButtonModbusTCP.Checked) Then
                Try
                    res = ModbusTCPCom1.Read("304003", 2)
                    PanelConnection.BackColor = Color.Green
                    LabelConnectionStatus.Text = "Connected"
                    PollInfoCounter += 2
                Catch
                    TimerCheckStatus.Enabled = False
                    res = {"0", "0"}
                    PanelConnection.BackColor = Color.Red
                    LabelConnectionStatus.Text = "Disconnected"
                End Try

            End If

            Dim _StopBit = Convert.ToInt32(res(0)) And &H8
            Dim _EnableBit = Convert.ToInt32(res(0)) And &H1
            Dim _homedBit = Convert.ToInt32(res(0)) And &H2
            Dim _inMotionBit = Convert.ToInt32(res(0)) And &H4

            Dim _brakeBit = Convert.ToInt32(res(1)) And &H10
            Dim _hostControlBit = Convert.ToInt32(res(1)) And &H8000


            If (_StopBit > 0) Then
                PilotLightESTOP.Value = True
            Else
                PilotLightESTOP.Value = False
            End If

            If (_EnableBit > 0) Then
                PilotLightEnable.Value = True
            Else
                PilotLightEnable.Value = False
            End If

            If (_homedBit > 0) Then
                PilotLightHomed.Value = True
            Else
                PilotLightHomed.Value = False
            End If

            If (_inMotionBit > 0) Then
                PilotLightInMotion.Value = True
            Else
                PilotLightInMotion.Value = False
            End If

            'When brake bit is high, then brake is not active, so we invert
            If (_brakeBit > 0) Then
                PilotLightBrake.Value = False
            Else
                PilotLightBrake.Value = True
            End If

            If (_hostControlBit > 0) Then
                PilotLightHostInControl.Value = True
            Else
                PilotLightHostInControl.Value = False
            End If

            Dim StopTime As DateTime = DateTime.Now

            Dim TotalTime As TimeSpan = StopTime.Subtract(startTime)

            LabelPollInformation.Text = PollInfoCounter.ToString() + " Registers in" + vbCrLf + TotalTime.TotalSeconds.ToString() + " Seconds"

            Running = False
        End If

    End Sub

    Private Sub CheckPosition()

        Dim res As String()
        res = {String.Empty, String.Empty} 'Two registers contain status


        Try

            If (RadioButtonModbusTCP.Checked) Then
                Try
                    res = ModbusTCPCom1.Read("304001", 2)
                    TimerCheckStatus.Enabled = True
                    PollInfoCounter += 2
                Catch
                    TimerCheckStatus.Enabled = False
                End Try

            End If

        Catch
            Return
        End Try


        Try
            'String to bytes to float
            Dim bytes(4) As Byte

            Dim bytes0() As Byte = BitConverter.GetBytes(Convert.ToInt16(res(0)))
            Dim bytes1() As Byte = BitConverter.GetBytes(Convert.ToInt16(res(1)))

            bytes0.CopyTo(bytes, 0)
            bytes1.CopyTo(bytes, 2)

            Dim position As Single = BitConverter.ToSingle(bytes, 0)

            LabelCurrentPosition.Text = position.ToString() + " mm"
        Catch
            Return

        End Try
    End Sub

    Private Sub CheckFaults()

            Dim res As String()
            res = {String.Empty, String.Empty} 'Two registers contain status

            If (RadioButtonModbusTCP.Checked) Then
                Try
                res = ModbusTCPCom1.Read("304005", 2)
                PollInfoCounter += 2

            Catch
                res = {"0", "0"}
            End Try

            End If

        Dim _PosLimit = Convert.ToInt32(res(0)) And Convert.ToInt32("1", 2)
        Dim _NegLimit = Convert.ToInt32(res(0)) And Convert.ToInt32("10", 2)
        Dim _ESTOPBit = Convert.ToInt32(res(0)) And Convert.ToInt32("100", 2)
        Dim _PosError = Convert.ToInt32(res(0)) And Convert.ToInt32("1000", 2)
        Dim _FeedbackErr = Convert.ToInt32(res(0)) And Convert.ToInt32("10000", 2)
        Dim _OverCurrent = Convert.ToInt32(res(0)) And Convert.ToInt32("100000", 2)
        '  Dim _MotorOverTemp = Convert.ToInt32(res(0)) And Convert.ToInt32("1000000", 2) ' Not currently supported.  Some drives use Feedback Fault as temp protection
        Dim _OverTemp = Convert.ToInt32(res(0)) And Convert.ToInt32("10000000", 2)
        Dim _OverVoltage = Convert.ToInt32(res(0)) And Convert.ToInt32("100000000", 2)
        Dim _UnderVoltage = Convert.ToInt32(res(0)) And Convert.ToInt32("1000000000", 2)
        Dim _FlashErr = Convert.ToInt32(res(0)) And Convert.ToInt32("10000000000", 2)
        Dim _I2TErr = Convert.ToInt32(res(0)) And Convert.ToInt32("100000000000", 2)
        Dim _ShortCirErr = Convert.ToInt32(res(0)) And Convert.ToInt32("1000000000000", 2)
        Dim _Watchdog = Convert.ToInt32(res(0)) And Convert.ToInt32("10000000000000", 2)

        If (_PosLimit > 0) Then
            PilotLightPositiveLimit.Value = True
        Else
            PilotLightPositiveLimit.Value = False
        End If

        If (_NegLimit > 0) Then
            PilotLightNegativeLimit.Value = True
        Else
            PilotLightNegativeLimit.Value = False
        End If

        If (_ESTOPBit > 0) Then
            PilotLightestopFault.Value = True
        Else
            PilotLightestopFault.Value = False
        End If

        If (_PosError > 0) Then
            PilotLightPositionError.Value = True
        Else
            PilotLightPositionError.Value = False
        End If

        If (_FeedbackErr > 0) Then
            PilotLightFeedback.Value = True
        Else
            PilotLightFeedback.Value = False
        End If

        If (_OverCurrent > 0) Then
            PilotLightOvercurrent.Value = True
        Else
            PilotLightOvercurrent.Value = False
        End If

        If (_OverTemp > 0) Then
            PilotLightDriveTemp.Value = True
        Else
            PilotLightDriveTemp.Value = False
        End If

        If (_OverVoltage > 0) Then
            PilotLightOverVolt.Value = True
        Else
            PilotLightOverVolt.Value = False
        End If

        If (_UnderVoltage > 0) Then
            PilotLightUnderVoltage.Value = True
        Else
            PilotLightUnderVoltage.Value = False
        End If

        If (_FlashErr > 0) Then
            PilotLightFlashErr.Value = True
        Else
            PilotLightFlashErr.Value = False
        End If

        If (_I2TErr > 0) Then
            PilotLightI2T.Value = True
        Else
            PilotLightI2T.Value = False
        End If

        If (_ShortCirErr > 0) Then
            PilotLightShortCircuit.Value = True
        Else
            PilotLightShortCircuit.Value = False
        End If

        If (_Watchdog > 0) Then
            PilotLightWatchdog.Value = True
        Else
            PilotLightWatchdog.Value = False
        End If

    End Sub

    Private Sub UpdateDigitalInputs()
        Dim res As String()
        res = {String.Empty, String.Empty} 'Two registers contain status

        If (RadioButtonModbusTCP.Checked) Then
            Try
                res = ModbusTCPCom1.Read("304007", 2)
                PollInfoCounter += 2
            Catch
                res = {"0", "0"}
            End Try

        End If

        Dim _Bit1 = Convert.ToInt32(res(0)) And Convert.ToInt32("1", 2)
        Dim _Bit2 = Convert.ToInt32(res(0)) And Convert.ToInt32("10", 2)
        Dim _Bit3 = Convert.ToInt32(res(0)) And Convert.ToInt32("100", 2)
        Dim _Bit4 = Convert.ToInt32(res(0)) And Convert.ToInt32("1000", 2)
        Dim _Bit5 = Convert.ToInt32(res(0)) And Convert.ToInt32("10000", 2)
        Dim _Bit6 = Convert.ToInt32(res(0)) And Convert.ToInt32("100000", 2)
        Dim _Bit7 = Convert.ToInt32(res(0)) And Convert.ToInt32("1000000", 2)
        Dim _Bit8 = Convert.ToInt32(res(0)) And Convert.ToInt32("10000000", 2)

        If (_Bit1 > 0) Then
            CheckBoxInput1.Checked = True
        Else
            CheckBoxInput1.Checked = False
        End If

        If (_Bit2 > 0) Then
            CheckBoxInput2.Checked = True
        Else
            CheckBoxInput2.Checked = False
        End If
        If (_Bit3 > 0) Then
            CheckBoxInput3.Checked = True
        Else
            CheckBoxInput3.Checked = False
        End If
        If (_Bit4 > 0) Then
            CheckBoxInput4.Checked = True
        Else
            CheckBoxInput4.Checked = False
        End If
        If (_Bit5 > 0) Then
            CheckBoxInput5.Checked = True
        Else
            CheckBoxInput5.Checked = False
        End If
        If (_Bit6 > 0) Then
            CheckBoxInput6.Checked = True
        Else
            CheckBoxInput6.Checked = False
        End If
        If (_Bit7 > 0) Then
            CheckBoxInput7.Checked = True
        Else
            CheckBoxInput7.Checked = False
        End If
        If (_Bit8 > 0) Then
            CheckBoxInput8.Checked = True
        Else
            CheckBoxInput8.Checked = False
        End If
        
    End Sub
    
    Private Sub ComboBoxMoveSelect_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBoxMoveSelect.SelectedIndexChanged
        '       Dim value As Integer

        '        Try
        'value = Convert.ToInt16(ComboBoxMoveSelect.Text)
        'Catch
        ' Return
        ' End Try

        '        If (RadioButtonModbusTCP.Checked) Then
        'Try
        ' ModbusTCPCom1.Write("404002", value.ToString())
        ' TimerCheckStatus.Enabled = True
        '  PanelConnection.BackColor = Color.Green
        '  LabelConnectionStatus.Text = "Connected"
        '  Catch
        ' TimerCheckStatus.Enabled = False
        ' PanelConnection.BackColor = Color.Red
        ' LabelConnectionStatus.Text = "Disconnected"
        ' End Try
        '
        '        End If
    End Sub

    Private Sub TextBoxPosition_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBoxPosition.TextChanged
        Try
            Dim test As Single = Convert.ToSingle(TextBoxPosition.Text)
            UpdateTargets()
        Catch

        End Try

    End Sub

    Private Sub TextBoxVelocity_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBoxVelocity.TextChanged
        Try
            Dim test As Single = Convert.ToSingle(TextBoxVelocity.Text)
            UpdateTargets()
        Catch

        End Try
    End Sub

    Private Sub TextBoxAccel_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBoxAccel.TextChanged
        Try
            Dim test As Single = Convert.ToSingle(TextBoxAccel.Text)
            UpdateTargets()
        Catch

        End Try
    End Sub

    Private Sub TextBoxDecel_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBoxDecel.TextChanged
        Try
            Dim test As Single = Convert.ToSingle(TextBoxDecel.Text)
            UpdateTargets()
        Catch

        End Try
    End Sub

    Private Sub TextBoxForce_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBoxForce.TextChanged
        Try
            Dim test As Single = Convert.ToSingle(TextBoxForce.Text)
            UpdateTargets()
        Catch

        End Try
    End Sub

    Sub UpdateTargets()
        If (Initialized) Then

            Try

                'String to float to bytes
                Dim bytes() As Byte = BitConverter.GetBytes(Convert.ToSingle(TextBoxPosition.Text))

                'Bytes to integer
                Dim int As Integer = BitConverter.ToInt32(bytes, 0)

                Dim int0 As Integer = int And 65535
                Dim int1 As Integer = (int >> 16) And 65535
                If (RadioButtonModbusTCP.Checked) Then
                    Try
                        ModbusTCPCom1.Write("404003", int0.ToString())
                        ModbusTCPCom1.Write("404004", int1.ToString())
                        TimerCheckStatus.Enabled = True
                        PanelConnection.BackColor = Color.Green
                        LabelConnectionStatus.Text = "Connected"
                        TextBoxPosition.ForeColor = Color.Green
                    Catch
                        TimerCheckStatus.Enabled = False
                        PanelConnection.BackColor = Color.Red
                        LabelConnectionStatus.Text = "Disconnected"
                        TextBoxPosition.ForeColor = Color.Red
                        Return
                    End Try

                End If
            Catch

            End Try

            Try
                'String to float to bytes
                Dim bytes() As Byte = BitConverter.GetBytes(Convert.ToSingle(TextBoxVelocity.Text))

                'Bytes to integer
                Dim int As Integer = BitConverter.ToInt32(bytes, 0)

                Dim int0 As Integer = int And 65535
                Dim int1 As Integer = (int >> 16) And 65535
                If (RadioButtonModbusTCP.Checked) Then
                    Try
                        ModbusTCPCom1.Write("404005", int0.ToString())
                        ModbusTCPCom1.Write("404006", int1.ToString())
                        TimerCheckStatus.Enabled = True
                        TextBoxVelocity.ForeColor = Color.Green
                    Catch
                        TimerCheckStatus.Enabled = False
                        TextBoxVelocity.ForeColor = Color.Red
                    End Try

                End If

            Catch

            End Try

            Try
                'String to float to bytes
                Dim bytes() As Byte = BitConverter.GetBytes(Convert.ToSingle(TextBoxAccel.Text))

                'Bytes to integer
                Dim int As Integer = BitConverter.ToInt32(bytes, 0)

                Dim int0 As Integer = int And 65535
                Dim int1 As Integer = (int >> 16) And 65535
                If (RadioButtonModbusTCP.Checked) Then
                    Try
                        ModbusTCPCom1.Write("404007", int0.ToString())
                        ModbusTCPCom1.Write("404008", int1.ToString())
                        TimerCheckStatus.Enabled = True
                        TextBoxAccel.ForeColor = Color.Green
                    Catch
                        TimerCheckStatus.Enabled = False
                        TextBoxAccel.ForeColor = Color.Red
                    End Try

                End If

            Catch

            End Try

            Try
                'String to float to bytes
                Dim bytes() As Byte = BitConverter.GetBytes(Convert.ToSingle(TextBoxDecel.Text))

                'Bytes to integer
                Dim int As Integer = BitConverter.ToInt32(bytes, 0)

                Dim int0 As Integer = int And 65535
                Dim int1 As Integer = (int >> 16) And 65535
                If (RadioButtonModbusTCP.Checked) Then
                    Try
                        ModbusTCPCom1.Write("404009", int0.ToString())
                        ModbusTCPCom1.Write("404010", int1.ToString())
                        TimerCheckStatus.Enabled = True
                        TextBoxDecel.ForeColor = Color.Green
                    Catch
                        TimerCheckStatus.Enabled = False
                        TextBoxDecel.ForeColor = Color.Red
                    End Try

                End If

            Catch

            End Try

            Try
                'String to float to bytes
                Dim bytes() As Byte = BitConverter.GetBytes(Convert.ToSingle(TextBoxForce.Text))

                'Bytes to integer
                Dim int As Integer = BitConverter.ToInt32(bytes, 0)

                Dim int0 As Integer = int And 65535
                Dim int1 As Integer = (int >> 16) And 65535
                If (RadioButtonModbusTCP.Checked) Then
                    Try
                        ModbusTCPCom1.Write("404011", int0.ToString())
                        ModbusTCPCom1.Write("404012", int1.ToString())
                        TimerCheckStatus.Enabled = True
                        TextBoxForce.ForeColor = Color.Green
                    Catch
                        TimerCheckStatus.Enabled = False
                        TextBoxForce.ForeColor = Color.Red
                    End Try

                End If

            Catch

            End Try

            Try
                'Bytes to integer
                Dim int As Integer = ComboBoxMotionType.SelectedIndex

                If (RadioButtonModbusTCP.Checked) Then
                    Try
                        ModbusTCPCom1.Write("404013", int.ToString())
                        TimerCheckStatus.Enabled = True
                        ComboBoxMotionType.ForeColor = Color.Green
                    Catch
                        TimerCheckStatus.Enabled = False
                        ComboBoxMotionType.ForeColor = Color.Red
                    End Try

                End If

                ComboBoxMoveSelect.Text = "0"

            Catch

            End Try
        End If

    End Sub

    Private Sub ComboBox1_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles ComboBoxMotionType.SelectedIndexChanged
        UpdateTargets()
    End Sub

    Private Sub RadioButtonModbusTCP_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles RadioButtonModbusTCP.CheckedChanged
        TimerCheckStatus.Enabled = True
    End Sub

    Private Sub RadioButtonModbusRTU_CheckedChanged(sender As System.Object, e As System.EventArgs)
        TimerCheckStatus.Enabled = True
    End Sub

    Private Sub MainForm_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing

    End Sub

    Private Sub CheckBoxOutput1_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxOutput1.CheckedChanged
        UpdateDigitalOutputControl()
    End Sub

    Private Sub UpdateDigitalOutputControl()
        Dim target As Integer

        If (CheckBoxOutput1.Checked) Then
            target = target Or 1
        End If

        If (CheckBoxOutput2.Checked) Then
            target = target Or (1 << 1)
        End If

        If (CheckBoxOutput3.Checked) Then
            target = target Or (1 << 2)
        End If

        If (CheckBoxOutput4.Checked) Then
            target = target Or (1 << 3)
        End If

        Try
            If (RadioButtonModbusTCP.Checked) Then
                Try
                    ModbusTCPCom1.Write("404015", target.ToString())
                    TimerCheckStatus.Enabled = True
                Catch
                    TimerCheckStatus.Enabled = False
                End Try

            End If
        Catch

        End Try
    End Sub



    Private Sub CheckBoxOutput2_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxOutput2.CheckedChanged
        UpdateDigitalOutputControl()
    End Sub

    Private Sub CheckBoxOutput3_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxOutput3.CheckedChanged
        UpdateDigitalOutputControl()
    End Sub

    Private Sub CheckBoxOutput4_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxOutput4.CheckedChanged
        UpdateDigitalOutputControl()
    End Sub

    Private Sub CheckBoxInput3_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxInput3.CheckedChanged

    End Sub

    Private Sub ButtonPing_Click(sender As System.Object, e As System.EventArgs) Handles ButtonPing.Click
        Dim ping As System.Net.NetworkInformation.Ping = New System.Net.NetworkInformation.Ping()
        Try
            Dim reply As System.Net.NetworkInformation.PingReply = ping.Send(TextBoxIPAddress.Text)

            MessageBox.Show(reply.Status.ToString(), "Ping Result")
        Catch
            MessageBox.Show("Ping Failed")
        End Try

    End Sub

    Private Sub PictureBoxModbus_Click(sender As System.Object, e As System.EventArgs) Handles PictureBoxModbus.Click

        System.Diagnostics.Process.Start("http://www.tolomatic.com/")

    End Sub

    Private Sub PictureBox1_Click(sender As System.Object, e As System.EventArgs) Handles PictureBox1.Click
        System.Diagnostics.Process.Start("http://www.modbus.org/docs/Modbus_Application_Protocol_V1_1b.pdf")
    End Sub

    Private Sub CheckBoxStartMotTog_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles CheckBoxStartMotTog.CheckedChanged
        If CheckBoxStartMotTog.Checked Then
            TimerStartMotTog.Enabled = True
        Else
            TimerStartMotTog.Enabled = False
        End If
    End Sub

    Private Sub TimerStartMotTog_Tick(sender As System.Object, e As System.EventArgs) Handles TimerStartMotTog.Tick

        ButtonStartMotion_Click(sender, e)

    End Sub
End Class
